<?php
/*
Plugin Name: Responsive Twenty Ten
Plugin URI: https://www.kessler-design.com/responsive-twenty-ten/
Description: Make Twenty Ten theme responsive, remove block css in frontend if Classic Editor is active
Author: Thomas Kessler
Author URI: https://www.kessler-design.com/
Version: 1.4.3
Update URI: https://www.kessler-design.com/plugins/
*/

function rtt_init() {
	if (
		wp_get_theme()->get('Name') !== 'Twenty Ten'
		&& wp_get_theme( wp_get_theme()->get('Template') )->get('Name') !== 'Twenty Ten'
	) {
		return;
	}

	function rtt_plugin_add_styles() {
		wp_enqueue_style( 'responsivetwentyten',  plugins_url('css/responsivetwentyten.min.css', __FILE__), false, '1.4.3' );
	}
	add_action( 'wp_enqueue_scripts', 'rtt_plugin_add_styles' );

	function rtt_plugin_ie8_support() {
		return apply_filters( 'rtt_ie8_support', true );
	}

	function rtt_plugin_add_meta() {
		echo '<!-- Responsive Twenty Ten - Thomas Kessler, www.kessler-design.com -->' . "\r\n";
		if ( rtt_plugin_ie8_support() ) {
			echo '<!--[if IE 8]>' . "\r\n";
			echo '<link rel="stylesheet" href="' . plugins_url('css/responsivetwentyten-ie8.min.css', __FILE__) . '?ver=1.4" type="text/css" media="all" />' . "\r\n";
			echo '<script src="' . plugins_url('js/css3-mediaqueries.js', __FILE__). '"></script>' . "\r\n";
			echo '<![endif]-->' . "\r\n";
		}
		echo '<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=5.0" />' . "\r\n";
	}
	add_action( 'wp_head', 'rtt_plugin_add_meta' );

	// example how to disable/enable IE8 support via filter from anywhere
	function rtt_plugin_ie8_support_filter( $state ) {
		return false;	// default: true = IE8 support enabled
	}
	add_filter( 'rtt_ie8_support' , 'rtt_plugin_ie8_support_filter' );

	// remove block css
	function rtt_remove_blockstyles() {
		// gutenberg
		if ( class_exists( 'Classic_Editor' ) ) {
			$allow_users = ( get_option( 'classic-editor-allow-users' ) === 'allow' );
			if ( !$allow_users ) {
				// https://smartwp.com/remove-gutenberg-css/
				// Remove Gutenberg Block Library CSS from loading on the frontend
				//wp_dequeue_style( 'wp-block-library' );
				// do not remove, used by Twenty Ten classic for image alignment

				//wp_dequeue_style( 'wp-block-library-theme' );
				wp_deregister_style( 'wp-block-library-theme' );	// deregister removes also ..-inline-css

				// https://www.kuketz-blog.de/wordpress-5-9-global-styles-inline-css-aus-header-entfernen/
				wp_dequeue_style( 'global-styles' );

				// https://www.webnots.com/remove-global-styles-inline-and-classic-theme-styles-inline-from-wordpress-header/
				// removes classic-theme-styles-inline-css
				wp_dequeue_style( 'classic-theme-styles' );
				
				// twentyten/functions.php @since Twenty Ten 2.6
				wp_dequeue_style( 'twentyten-block-style' );
			}
		}
	}
	add_action( 'wp_enqueue_scripts', 'rtt_remove_blockstyles', 11 );

}
add_action( 'init', 'rtt_init' );

// update all the things ...
add_filter( 'update_plugins_www.kessler-design.com', function( $update, $plugin_data, $plugin_file, $locales ) {
	if ( $plugin_file !== plugin_basename( __FILE__ ) ) {
		return $update;
	}

	if ( !empty( $update ) ) {
		return $update;
	}

	if ( !empty( $plugin_data['UpdateURI'] ) ) {
		$response = wp_remote_get(
			$plugin_data['UpdateURI'],
			array(
				'user-agent' => 'update_plugins_kd/1.0 ' . $plugin_file
			)
		);
		$response_body = wp_remote_retrieve_body( $response ); // includes check for WP_Error
		if ( !empty( $response_body ) ) {
			$json_arr = json_decode( $response_body, true );
			if ( $json_arr !== null ) {
				$update = $json_arr;
			}
		}
	}
	return $update;
} ,10, 4 );
add_filter( 'admin_url', function( $url ) {
	if (
		strpos(
			$url,
			'plugin-install.php?tab=plugin-information&plugin=' . dirname( plugin_basename( __FILE__ ) )
		) !== false	
	) {
		$plugin_data = get_plugin_data( __FILE__ );
		if ( !empty( $plugin_data['UpdateURI'] ) ) {
			$url = str_replace(
				admin_url( 'plugin-install.php' ),
				$plugin_data['UpdateURI'],
				$url
			);
		}
	}
	return $url;
});
